* Purpose of file: Defining variables that were also used in 2017 RDP analysis
* File author: Ani Yadav and Mary-Alice Doyle
* Date last edited: 20 May 2018
use ".\Data\2016 CPS - Finalised Dataset (main only).dta", clear
set more off

quietly{
* consolidated paymeth -- gift/prepaid is kept separate
recode paymethx (1 = 1) (2 3 = 2) (4 5 = 3) (7 8 = 4) (6 9 11 = 5), g(paymethcons)
label define paymethcons 1 "Cash" 2 "Debit" 3 "Credit" 4 "BPAY/NB" 5 "Other" 10 "Gift/prepaid"
label values paymethcons paymethcons

* consolidated paymeth cheques -- gift/prepaid included in Other!!!
recode paymethx (1 = 1) (2 3 4 5 = 2) (7 8 = 3) (6 = 4) (9 10 11 = 5), g(paymethcons2)
label define paymethcons2 1 "Cash" 2 "Card" 3 "BPAY/NB" 4 "Cheque" 5 "Other"
label values paymethcons2 paymethcons2

* consolidated paymeth
recode paymethx (2 3 = 2) (4 5 = 3), g(paymethcons3)
label define paymethcons3 1 "Cash" 2 "Debit" 3 "Credit" 6 "Cheque" 7 "BPAY" 8 "NetB" 9 "PayPal" 11 "Other" 10 "Gift/prepaid"
label values paymethcons3 paymethcons3

* paymeth for contactless sub
recode paymethx (1 = 1) (2 3 4 5 = 2) (6 7 8 9 10 11 = 4), g(paymethsub)
replace paymethsub = 4 if paychan != 1
replace paymethsub = 3 if cardact == 1
replace paymethsub = 5 if cardact == 4
label define paymethsub 1 "Cash" 2 "Contact" 3 "Tap/wave card" 4 "Other" 5 "Tap/wave phone"
label values paymethsub paymethsub

* consolidated channel
recode paychan (1 = 1) (2 3 4 5 = 2), g(paychancons)
label define paychancons 1 "Inperson" 2 "Remote"
label values paychancons paychancons


* DIFFERENT PAYMENT SIZE BUCKETS

* payamt bin #1
gen payamtr=ceil(payamt)
order payamtr, after(payamt)
egen payamtbinr = cut(payamtr), at(1 11 21 51 101 501 9999999)

* payamt bin #2
egen payamtbinr2 = cut(payamtr), at(1 11 21 51 101 9999999)

* payamt bin #3
egen payamtbinwave = cut(payamtr), at(1 6 11 26 51 101 501 9999999)

* payamt bin #4 quite granular
egen payamtbingran = cut(payamtr), at(1 11 21 31 41 51 61 71 81 91 101 501 9999999)

* payamt bin #5
egen payamtbinsub = cut(payamtr), at(1 6 11 21 31 51 76 101 501 9999999)

* capital and regional
recode state (1 3 5 7 9 11 13 15 = 1) (2 4 6 8 10 12 14 16 = 0), g(region)
label define region -5 "Missing" 0 "Regional" 1 "Capital"
label values region region

	
* dummy for whether respondent made a card payment
egen card_temp = total(payamtr) if inlist(paymethx,2,3,4,5), by(id)
egen cardpay = max(card_temp), by(id)
replace cardpay = 1 if cardpay!=.
replace cardpay = 0 if cardpay==.
drop card_temp


}
